/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.dimentions;

import java.io.IOException;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.GameType;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.storage.ISaveFormat;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import noppes.npcs.CustomNpcs;
import noppes.npcs.client.Client;
import noppes.npcs.client.gui.dimentions.GuiCreateFlatDimension;
import noppes.npcs.client.gui.dimentions.GuiCustomizeDimension;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.dimensions.CustomWorldInfo;
import noppes.npcs.entity.EntityNPCInterface;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class GuiCreateDimension
extends GuiScreen {
    private static final String[] disallowedFilenames = new String[]{"CON", "COM", "PRN", "AUX", "CLOCK$", "NUL", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9"};
    private GuiTextField dimensionNameTextField;
    private GuiTextField seedTextField;
    private String field_146336_i;
    private String gameType = "survival";
    private String field_175300_s;
    private boolean generateStructures = true;
    private boolean allowCheats;
    private boolean alreadyGenerated;
    private boolean userInMoreOptions;
    private GuiButton btnMoreOptions;
    private GuiButton btnStructures;
    private GuiButton btnDimensionType;
    private GuiButton btnCustomizeType;
    public String gameMode1;
    public String gameMode2;
    private String seedID = "";
    private String dimensionName = "custom_dimension";
    private int selectedIndex;
    public String chunkProviderSettingsJson = "";
    private final int dimensionId;

    public static String func_146317_a(ISaveFormat p_146317_0_, String p_146317_1_) {
        p_146317_1_ = p_146317_1_.replaceAll("[\\\\./\"]", "_");
        StringBuilder p_146317_1_Builder = new StringBuilder(p_146317_1_);
        for (String s1 : disallowedFilenames) {
            if (!p_146317_1_Builder.toString().equalsIgnoreCase(s1)) continue;
            p_146317_1_Builder = new StringBuilder("_" + p_146317_1_Builder + "_");
        }
        p_146317_1_ = p_146317_1_Builder.toString();
        while (p_146317_0_.func_75803_c(p_146317_1_) != null) {
            p_146317_1_ = p_146317_1_ + "-";
        }
        return p_146317_1_;
    }

    public GuiCreateDimension(int dimensionId) {
        this.dimensionId = dimensionId;
    }

    protected void func_146284_a(@Nonnull GuiButton button) throws IOException {
        if (!button.field_146124_l) {
            return;
        }
        if (button.field_146127_k == 1) {
            CustomNpcs.proxy.openGui((EntityNPCInterface)null, EnumGuiType.NpcDimensions);
        } else if (button.field_146127_k == 0) {
            CustomNpcs.proxy.openGui((EntityNPCInterface)null, EnumGuiType.NpcDimensions);
            if (this.alreadyGenerated) {
                return;
            }
            this.alreadyGenerated = true;
            long i = new Random().nextLong();
            String s = this.seedTextField.func_146179_b();
            if (!StringUtils.isEmpty((CharSequence)s)) {
                try {
                    long j = Long.parseLong(s);
                    if (j != 0L) {
                        i = j;
                    }
                }
                catch (NumberFormatException numberformatexception) {
                    i = s.hashCode();
                }
            }
            WorldType.field_77139_a[this.selectedIndex].onGUICreateWorldPress();
            WorldInfo worldInfo = this.getWorldInfo(i);
            Client.sendData(EnumPacketServer.DimensionSettings, this.dimensionId, worldInfo);
        } else if (button.field_146127_k == 3) {
            this.func_146315_i();
        } else if (button.field_146127_k == 4) {
            this.generateStructures = !this.generateStructures;
            this.updateDisplayState();
        } else if (button.field_146127_k == 5) {
            do {
                ++this.selectedIndex;
                if (this.selectedIndex < WorldType.field_77139_a.length) continue;
                this.selectedIndex = 0;
            } while (!this.func_175299_g());
            this.chunkProviderSettingsJson = "";
            this.updateDisplayState();
            this.showMoreWorldOptions(this.userInMoreOptions);
        } else if (button.field_146127_k == 8) {
            if (WorldType.field_77139_a[this.selectedIndex] == WorldType.field_77138_c) {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiCreateFlatDimension(this, this.chunkProviderSettingsJson));
            } else if (WorldType.field_77139_a[this.selectedIndex] == WorldType.field_180271_f) {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiCustomizeDimension(this, this.chunkProviderSettingsJson));
            }
        }
    }

    private WorldInfo getWorldInfo(long i) {
        GameType gametype = GameType.func_77142_a((String)this.gameType);
        boolean hardcore = false;
        WorldSettings worldsettings = new WorldSettings(i, gametype, this.generateStructures, hardcore, WorldType.field_77139_a[this.selectedIndex]);
        worldsettings.func_82750_a(this.chunkProviderSettingsJson);
        if (this.allowCheats && !hardcore) {
            worldsettings.func_77166_b();
        }
        return new CustomWorldInfo(worldsettings, this.dimensionNameTextField.func_146179_b().trim());
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.func_73732_a(this.field_146289_q, new TextComponentTranslation("dimensions.create", new Object[0]).func_150254_d(), this.field_146294_l / 2, 20, -1);
        if (this.userInMoreOptions) {
            this.func_73731_b(this.field_146289_q, new TextComponentTranslation("selectWorld.enterSeed", new Object[0]).func_150254_d(), this.field_146294_l / 2 - 100, 47, -6250336);
            this.func_73731_b(this.field_146289_q, new TextComponentTranslation("selectWorld.seedInfo", new Object[0]).func_150254_d(), this.field_146294_l / 2 - 100, 85, -6250336);
            if (this.btnStructures.field_146125_m) {
                this.func_73731_b(this.field_146289_q, new TextComponentTranslation("selectWorld.mapFeatures.info", new Object[0]).func_150254_d(), this.field_146294_l / 2 - 150, 122, -6250336);
            }
            this.seedTextField.func_146194_f();
            if (WorldType.field_77139_a[this.selectedIndex].func_151357_h()) {
                this.field_146289_q.func_78279_b(new TextComponentTranslation(WorldType.field_77139_a[this.selectedIndex].func_151359_c(), new Object[0]).func_150254_d(), this.btnDimensionType.field_146128_h + 2, this.btnDimensionType.field_146129_i + 22, this.btnDimensionType.func_146117_b(), 0xA0A0A0);
            }
        } else {
            this.func_73731_b(this.field_146289_q, new TextComponentTranslation("dimensions.enter.name", new Object[0]).func_150254_d(), this.field_146294_l / 2 - 100, 47, -6250336);
            this.func_73731_b(this.field_146289_q, new TextComponentTranslation("selectWorld.resultFolder", new Object[0]).func_150254_d() + " " + this.field_146336_i, this.field_146294_l / 2 - 100, 85, -6250336);
            this.dimensionNameTextField.func_146194_f();
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    private void func_146314_g() {
        char[] aChar;
        this.field_146336_i = this.dimensionNameTextField.func_146179_b().toLowerCase().trim();
        while (this.field_146336_i.contains(" ")) {
            this.field_146336_i = this.field_146336_i.replace(" ", "_");
        }
        for (char c0 : aChar = ChatAllowedCharacters.field_71567_b) {
            this.field_146336_i = this.field_146336_i.replace(c0, '_');
        }
        if (StringUtils.isEmpty((CharSequence)this.field_146336_i)) {
            this.field_146336_i = "World";
        }
        this.field_146336_i = GuiCreateDimension.func_146317_a(this.field_146297_k.func_71359_d(), this.field_146336_i);
    }

    private void func_146315_i() {
        this.showMoreWorldOptions(!this.userInMoreOptions);
    }

    public void func_146318_a(WorldInfo p_146318_1_) {
        this.dimensionName = new TextComponentTranslation("selectWorld.newWorld.copyOf", new Object[]{p_146318_1_.func_76065_j()}).func_150254_d();
        this.seedID = p_146318_1_.func_76063_b() + "";
        this.selectedIndex = p_146318_1_.func_76067_t().func_82747_f();
        this.chunkProviderSettingsJson = p_146318_1_.func_82571_y();
        this.generateStructures = p_146318_1_.func_76089_r();
        this.allowCheats = p_146318_1_.func_76086_u();
        if (p_146318_1_.func_76093_s()) {
            this.gameType = "hardcore";
        } else if (p_146318_1_.func_76077_q().func_77144_e()) {
            this.gameType = "survival";
        } else if (p_146318_1_.func_76077_q().func_77145_d()) {
            this.gameType = "creative";
        }
    }

    private boolean func_175299_g() {
        WorldType worldtype = WorldType.field_77139_a[this.selectedIndex];
        return worldtype != null && worldtype.func_77126_d() && (worldtype != WorldType.field_180272_g || GuiCreateDimension.func_146272_n());
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.field_146292_n.clear();
        this.field_146292_n.add(new GuiButton(0, this.field_146294_l / 2 - 155, this.field_146295_m - 28, 150, 20, new TextComponentTranslation("dimensions.create", new Object[0]).func_150254_d()));
        this.field_146292_n.add(new GuiButton(1, this.field_146294_l / 2 + 5, this.field_146295_m - 28, 150, 20, new TextComponentTranslation("gui.cancel", new Object[0]).func_150254_d()));
        this.btnMoreOptions = new GuiButton(3, this.field_146294_l / 2 - 75, 187, 150, 20, new TextComponentTranslation("dimensions.more.dimension.options", new Object[0]).func_150254_d());
        this.field_146292_n.add(this.btnMoreOptions);
        this.btnStructures = new GuiButton(4, this.field_146294_l / 2 - 155, 100, 150, 20, new TextComponentTranslation("selectWorld.mapFeatures", new Object[0]).func_150254_d());
        this.field_146292_n.add(this.btnStructures);
        this.btnStructures.field_146125_m = false;
        this.btnDimensionType = new GuiButton(5, this.field_146294_l / 2 + 5, 100, 150, 20, new TextComponentTranslation("selectWorld.mapType", new Object[0]).func_150254_d());
        this.field_146292_n.add(this.btnDimensionType);
        this.btnDimensionType.field_146125_m = false;
        this.btnCustomizeType = new GuiButton(8, this.field_146294_l / 2 + 5, 120, 150, 20, new TextComponentTranslation("selectWorld.customizeType", new Object[0]).func_150254_d());
        this.field_146292_n.add(this.btnCustomizeType);
        this.btnCustomizeType.field_146125_m = false;
        this.dimensionNameTextField = new GuiTextField(9, this.field_146289_q, this.field_146294_l / 2 - 100, 60, 200, 20);
        this.dimensionNameTextField.func_146195_b(true);
        this.dimensionNameTextField.func_146180_a(this.dimensionName);
        this.seedTextField = new GuiTextField(10, this.field_146289_q, this.field_146294_l / 2 - 100, 60, 200, 20);
        this.seedTextField.func_146180_a(this.seedID);
        this.showMoreWorldOptions(this.userInMoreOptions);
        this.func_146314_g();
        this.updateDisplayState();
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        if (this.dimensionNameTextField.func_146206_l() && !this.userInMoreOptions) {
            this.dimensionNameTextField.func_146201_a(typedChar, keyCode);
            this.dimensionName = this.dimensionNameTextField.func_146179_b().toLowerCase();
            while (this.dimensionName.contains(" ")) {
                this.dimensionName = this.dimensionName.replace(" ", "_");
            }
        } else if (this.seedTextField.func_146206_l() && this.userInMoreOptions) {
            this.seedTextField.func_146201_a(typedChar, keyCode);
            this.seedID = this.seedTextField.func_146179_b();
        }
        if (keyCode == 28 || keyCode == 156) {
            this.func_146284_a((GuiButton)this.field_146292_n.get(0));
        }
        ((GuiButton)this.field_146292_n.get((int)0)).field_146124_l = !this.dimensionNameTextField.func_146179_b().isEmpty();
        this.func_146314_g();
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (this.userInMoreOptions) {
            this.seedTextField.func_146192_a(mouseX, mouseY, mouseButton);
        } else {
            this.dimensionNameTextField.func_146192_a(mouseX, mouseY, mouseButton);
        }
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    private void showMoreWorldOptions(boolean toggle) {
        this.userInMoreOptions = toggle;
        if (WorldType.field_77139_a[this.selectedIndex] == WorldType.field_180272_g) {
            if (this.field_175300_s == null) {
                this.field_175300_s = this.gameType;
            }
            this.gameType = "spectator";
            this.btnStructures.field_146125_m = false;
            this.btnDimensionType.field_146125_m = this.userInMoreOptions;
            this.btnCustomizeType.field_146125_m = false;
        } else {
            if (this.field_175300_s != null) {
                this.gameType = this.field_175300_s;
                this.field_175300_s = null;
            }
            this.btnStructures.field_146125_m = this.userInMoreOptions && WorldType.field_77139_a[this.selectedIndex] != WorldType.field_180271_f;
            this.btnDimensionType.field_146125_m = this.userInMoreOptions;
            this.btnCustomizeType.field_146125_m = this.userInMoreOptions && WorldType.field_77139_a[this.selectedIndex].isCustomizable();
        }
        this.updateDisplayState();
        this.btnMoreOptions.field_146126_j = this.userInMoreOptions ? new TextComponentTranslation("gui.done", new Object[0]).func_150254_d() : new TextComponentTranslation("dimensions.more.dimension.options", new Object[0]).func_150254_d();
    }

    private void updateDisplayState() {
        this.gameMode1 = new TextComponentTranslation("selectWorld.gameMode." + this.gameType + ".line1", new Object[0]).func_150254_d();
        this.gameMode2 = new TextComponentTranslation("selectWorld.gameMode." + this.gameType + ".line2", new Object[0]).func_150254_d();
        this.btnStructures.field_146126_j = new TextComponentTranslation("selectWorld.mapFeatures", new Object[0]).func_150254_d() + " ";
        this.btnStructures.field_146126_j = this.generateStructures ? this.btnStructures.field_146126_j + new TextComponentTranslation("options.on", new Object[0]).func_150254_d() : this.btnStructures.field_146126_j + new TextComponentTranslation("options.off", new Object[0]).func_150254_d();
        this.btnDimensionType.field_146126_j = new TextComponentTranslation("selectWorld.mapType", new Object[0]).func_150254_d() + " " + new TextComponentTranslation(WorldType.field_77139_a[this.selectedIndex].func_77128_b(), new Object[0]).func_150254_d();
    }

    public void func_73876_c() {
        this.dimensionNameTextField.func_146178_a();
        this.seedTextField.func_146178_a();
    }
}

